<?php
$signature_checkout_position = get_option('signature_checkout_position','before_billing');
if($signature_checkout_position == 'before_billing'){
	add_action('woocommerce_before_checkout_billing_form', 'DSCFW_add_signature_field');
}else{
	add_action('woocommerce_after_checkout_billing_form', 'DSCFW_add_signature_field');
}
function DSCFW_add_signature_field($post)
{
	$signature_width = get_option('signature_width',300);
	$signature_height = get_option('signature_height',200);
	$translation_drawsignature = get_option('translation_drawsignature','Draw Signature');
	$translation_clear = get_option('translation_clear','Clear');
	$dscfw_products = get_option('dscfw_products', '');

	// Get cart items
	$cart_items = WC()->cart->get_cart();
	$allowed_products = [];
	$pass = false;
	if(!empty($dscfw_products)){
		$allowed_products = explode(',', $dscfw_products);
		foreach ($cart_items as $cart_item) {
		    $product_id = $cart_item['product_id']; 

		    if (in_array($product_id, $allowed_products)) {
		        $pass = true;
		        break; // Exit loop early if a match is found
		    }
		}
	} else {
	    $pass = true;
	}

	if ($pass) {
		?>
		<div class="ocsignturefield">
			<h3><?php echo esc_html($translation_drawsignature); ?></h3>
			<canvas id="dscfw_sign" name="signaturefield" width="<?php echo esc_attr($signature_width); ?>" height="<?php echo esc_attr($signature_height); ?>"></canvas>
			<button class="clearButton" type="button"><?php echo esc_html($translation_clear); ?></button>	
			<input type="hidden" name="signpad" value="">	
		</div>	
		<?php
	}
	
}

add_action('woocommerce_checkout_process', 'ocvalidate_canvas_signature_field');

function ocvalidate_canvas_signature_field() {
	$dscfw_required = get_option('dscfw_required','false');
	$translation_clear = get_option('translation_validation','Please draw your signature.');

	$dscfw_products = get_option('dscfw_products', '');
	$cart_items = WC()->cart->get_cart();
	$pass = false;

	if (!empty($dscfw_products)) {
		$allowed_products = explode(',', $dscfw_products);
		foreach ($cart_items as $cart_item) {
			$product_id = $cart_item['product_id'];
			if (in_array($product_id, $allowed_products)) {
				$pass = true;
				break;
			}
		}
	} else {
		$pass = true;
	}

	if ($dscfw_required == 'true' && $pass) {
	    if (empty($_POST['signpad'])) {
	        wc_add_notice($translation_clear, 'error');
	    }
	}
}

add_action('woocommerce_checkout_update_order_meta', 'DSCFW_product_get_data');
function DSCFW_product_get_data($post){
	// print_r($_REQUEST['signpad']);
	// exit();       
	$signature_imgid = false;
	if (is_string($_REQUEST['signpad']) && strrpos($_REQUEST['signpad'], "data:image/png;base64", -strlen($_REQUEST['signpad'])) !== FALSE){

		$signature_imgid = DSCFW_save_image(  $_REQUEST['signpad'],'fff' );
                 
	}
	if (isset($_REQUEST['signpad']) && $signature_imgid !== false){
		update_post_meta($post, 'signpad', $signature_imgid);
	}
}

function DSCFW_save_image( $base64_img, $title ) {

	// Upload dir.
	$upload_dir  = wp_upload_dir();
	$upload_path = str_replace( '/', DIRECTORY_SEPARATOR, $upload_dir['path'] ) . DIRECTORY_SEPARATOR;

	$img             = str_replace( 'data:image/png;base64,', '', $base64_img );
	$img             = str_replace( ' ', '+', $img );
	$decoded         = base64_decode( $img );
	$filename        = $title.'.jpeg';
	$file_type       = 'image/jpeg';
	$hashed_filename = md5( $filename . microtime() ) . '_' . $filename;

	// Save the image in the uploads directory.
	$upload_file = file_put_contents( $upload_path . $hashed_filename, $decoded );

	$attachment = array(
		'post_mime_type' => $file_type,
		'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $hashed_filename ) ),
		'post_content'   => '',
		'post_status'    => 'inherit',
		'guid'           => $upload_dir['url'] . '/' . basename( $hashed_filename )
	);

	$attach_id = wp_insert_attachment( $attachment, $upload_dir['path'] . '/' . $hashed_filename );
	require_once( ABSPATH . 'wp-admin/includes/image.php' );
	// $attach_data = wp_generate_attachment_metadata( $attach_id, $hashed_filename );
	// wp_update_attachment_metadata( $attach_id, $attach_data );
	return $attach_id;
}

/* Display Signature Thankyou Page */
$signature_order_position = get_option('signature_order_position','inside_order_detail');

if($signature_order_position == 'inside_order_detail'){
	add_action('woocommerce_order_details_after_order_table_items', 'DSCFW_order_details');
}else{
	add_action('woocommerce_order_details_after_customer_details', 'DSCFW_order_details');
}
function DSCFW_order_details($order){
	$post_attach_file = get_post_meta($order->get_id(),'signpad',true);
	$signimage = wp_get_attachment_url($post_attach_file, true);
	if(!empty($signimage)){
	?>
	<section class="woocommerce-customer-details mycustomsection">
		<div class="woocommerce-order-details__title">
			<h2 class="signatureheading"><?php echo esc_html('Your Signature','digital-signature-checkout-for-woocommerce-pro'); ?></h2>
			<img src="<?Php echo esc_url($signimage); ?>" width="200" height="300">
		</div>
	</section>
	<?php
	}
}

add_action( 'woocommerce_admin_order_data_after_billing_address', 'DSCFW_checkout_field_display_admin_order_meta', 10, 1 );
function DSCFW_checkout_field_display_admin_order_meta($order){
	// $post_attach_file = $order->get_meta( 'signpad' );
	$post_attach_file = get_post_meta($order->get_id(),'signpad',true);
	$signimage = wp_get_attachment_url($post_attach_file, true);
	if(!empty($signimage)){
    	?> <img src="<?Php echo esc_url($signimage); ?>" width="100" height="100"> <?php
	}
}

add_action( 'woocommerce_email_order_details', 'DSCFW_action_wc_email_order_details', 50, 4 );
function DSCFW_action_wc_email_order_details( $order, $sent_to_admin, $plain_text, $email ){
	// $post_attach_file = $order->get_meta( 'signpad' );
	$post_attach_file = get_post_meta($order->get_id(),'signpad',true);
	$signimage = wp_get_attachment_url($post_attach_file, true);
	if(!empty($signimage)){
    ?>
        <h2 class="signatureheading"><?php echo esc_html('Your Signature','digital-signature-checkout-for-woocommerce-pro'); ?></h2>
    	<img src="<?Php echo esc_url($signimage); ?>" width="100" height="100">
    <?php
	}
}