<?php

use Automattic\WooCommerce\Blocks\Integrations\IntegrationInterface;

class Blocks_Integration implements IntegrationInterface {    
	public function get_name() {
		return 'gift-message';
	}
	
	public function initialize() {
		$this->register_block_frontend_scripts();
	}

	public function get_script_handles() {
		return array( 'DSCFW-front' );
	}

	public function get_editor_script_handles() {
		return array();
	}

	public function get_script_data() {
		return array();
	}
	
	public function register_block_frontend_scripts() {
		wp_register_script(
            'DSCFW-front',
            plugins_url( 'build/frontend.js', __FILE__ ),
            array( 'react', 'wc-blocks-checkout', 'wp-element', 'wp-i18n'),
        );
	}

}