(() => {
  "use strict";
  //console.log(wc.blocksCheckout.);
  // console.log(wc);
  const { useEffect } = window.wp.element;

  const { useSelect,dispatch,select } = window.wp.data;
  const { CHECKOUT_STORE_KEY,VALIDATION_STORE_KEY} = window.wc.wcBlocksData;
  // console.log(signaturecolors);
  const React = window.React;
  const blockMetadata = {
    $schema: "https://schemas.wp.org/trunk/block.json",
    apiVersion: 2,
    name: "checkout-block/digital-signature",
    version: "1.0.0",
    title: "Digital Signature",
    category: "woocommerce",
    parent: [signaturecolors.parent_target],
    attributes: {
      lock: {
        type: "object",
        default: { remove: true, move: true },
      },
    },
    textdomain: "checkout-block-example",
  };
  const wcBlocksCheckout = window.wc.blocksCheckout;
  const { registerCheckoutBlock } = wcBlocksCheckout;

  registerCheckoutBlock({
    metadata: blockMetadata,
    component: ({ children, checkoutExtensionData }) => {

      const canvasRef = React.useRef(null);
      const [canvasTouched, setCanvasTouched] = React.useState(false);

      const { setExtensionData} = checkoutExtensionData;
      const extensionData = select(CHECKOUT_STORE_KEY).getExtensionData();
      console.log(extensionData);
      const signatureData = extensionData?.['checkout-block-example']?.signature_data || '';
      console.log(signatureData);
      var backcolor = signaturecolors.signature_backcolor;
      var pencolor = signaturecolors.signature_penclr;
      var signature_width = signaturecolors.signature_width;
      var signature_height = signaturecolors.signature_height;
      var signature_required = signaturecolors.signature_required;
      var translation_drawsignature = signaturecolors.translation_drawsignature;
      var translation_clear = signaturecolors.translation_clear
      var pass = signaturecolors.pass;

      const validationErrorId = 'signature_data';
      const hasValidationError = select(VALIDATION_STORE_KEY).getValidationError( validationErrorId );

      // Signature Pad Initialization
      if (pass !== 'true') return; // Exit early if pass is not true

      React.useEffect(() => {
        if (signature_required == 'true') {
          dispatch(VALIDATION_STORE_KEY).setValidationErrors({
            [validationErrorId]: {
              message: 'Please select your country',
              hidden: false,
            },
          });
        }

        var dsPad = new SignaturePad(canvasRef.current, {
          backgroundColor: backcolor,
          penColor: pencolor,
        });

        var dsimgdata = dsPad.toDataURL('image/png');
        // console.log("dsimgdata", dsimgdata);
        const handleCanvasChange = () => {
          //console.log("ggg");
          if (signature_required == 'true') {
           dispatch( VALIDATION_STORE_KEY ).clearValidationError(
              validationErrorId
            );
          }
          var dsimgdata = dsPad.toDataURL('image/png');
          setExtensionData("checkout-block-example", "signature_data", dsimgdata);
          setCanvasTouched(true);
        };

        canvasRef.current.addEventListener('touchstart', handleCanvasChange);
        canvasRef.current.addEventListener('touchend', handleCanvasChange);
        canvasRef.current.addEventListener('click', handleCanvasChange);

        return () => {
          // Cleanup event listeners when the component unmounts
          if(canvasRef?.current){
            canvasRef.current.removeEventListener('touchstart', handleCanvasChange);
            canvasRef.current.removeEventListener('touchend', handleCanvasChange);
            canvasRef.current.removeEventListener('click', handleCanvasChange);
          }
        };
      }, [setExtensionData]);

      const handleClearButtonClick = (event) => {
        event.preventDefault();
        if (signature_required == 'true') {
          dispatch(VALIDATION_STORE_KEY).setValidationErrors({
            [validationErrorId]: {
              message: signaturecolors.translation_validation,
              hidden: false,
            },
          });
        }
        // console.log("handleClearButtonClick");
        const dsPad = new SignaturePad(canvasRef.current);
        dsPad.clear();
        setExtensionData("checkout-block-example", "signature_data", "");
        setCanvasTouched(false);
      };

      const canvasElement = React.createElement('canvas', {
        ref: canvasRef,
        width: signature_width,
        height: signature_height,
        style: { border: '1px solid black' },
        id: 'dscfw_sign',
      }, 'Your browser does not support the canvas element.');

      const clearButtonElement = React.createElement('button', {
        className: 'clearButton',
        onClick: handleClearButtonClick,
      }, translation_clear);

      if (signature_required == 'true') {
        var exampleFieldsElement = React.createElement(
          'div',
          { className: 'ocsignturefield' },
          React.createElement('h3', null, translation_drawsignature), // Adding heading
          hasValidationError && React.createElement(
              'div',
              { className: 'validation-error wc-block-components-validation-error' },
              signaturecolors.translation_validation
          ),
          canvasElement,
          clearButtonElement
        );
      } else {
        var exampleFieldsElement = React.createElement(
          'div',
          { className: 'ocsignturefield' },
          React.createElement('h3', null, translation_drawsignature), // Adding heading
          canvasElement,
          clearButtonElement
        );
      }

      return exampleFieldsElement;
    },
  });
})();
