<?php 
add_filter( 'woocommerce_settings_tabs_array', 'DSCFW_woocommerce_settings_tabs_array', 50 );
function DSCFW_woocommerce_settings_tabs_array( $tabs ) {
    $tabs['checkout-signature'] = __( 'Signature', 'digital-signature-checkout-for-woocommerce' );
    return $tabs;
}

add_action( 'woocommerce_settings_tabs_checkout-signature', 'DSCFW_display_checkout_signature_tab_content' );
function DSCFW_display_checkout_signature_tab_content() {?>
    <h3><?php echo esc_html('Styles','digital-signature-checkout-for-woocommerce'); ?></h3>
        <table class="form-table">
            <tr>
                <th><label><?php echo esc_html('Width','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td><input type="text" name="signature_width" value="<?php echo esc_attr(get_option('signature_width',300)); ?>"></td>
            </tr>
            <tr>
                <th><label><?php echo esc_html('Height','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td><input type="text" name="signature_height" value="<?php echo esc_attr(get_option('signature_height' ,200)); ?>"></td>
            </tr>
            <tr>
                <th><label><?php echo esc_html('Background Color','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td> <input type="text" class="color-picker" data-alpha="true" data-default-color="#d1d1d1" name="signature_backcolor" value="<?php echo esc_attr(get_option('signature_backcolor', '#d1d1d1')); ?>"></td>

            </tr>
            <tr>
                <th><label><?php echo esc_html('Pen Color','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td> <input type="text" class="color-picker" data-alpha="true" data-default-color="#000000" name="signature_penclr" value="<?php echo esc_attr(get_option('signature_penclr', '#000000')); ?>"></td>
            </tr>
            <tr>
                <th><label><?php echo esc_html('Signature Field Position On Checkout Page','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td> 
                   <div class="dscfw_border">
                        <label>
                            <input 
                                type="radio" 
                                name="signature_checkout_position" 
                                value="before_billing" 
                                <?php checked('before_billing', get_option("signature_checkout_position", "after_billing")); ?> 
                            />
                            <?php echo esc_html('Before Billing Details', 'digital-signature-checkout-for-woocommerce'); ?>
                        </label>
                        <label>
                            <input 
                                type="radio" 
                                name="signature_checkout_position" 
                                value="after_billing" 
                                <?php checked('after_billing', get_option("signature_checkout_position", "after_billing")); ?> 
                            />
                            <?php echo esc_html('After Billing Details', 'digital-signature-checkout-for-woocommerce'); ?>
                        </label>
                    </div>

                </td>
            </tr>
            <tr>
                <th><label><?php echo esc_html('Signature Field Position On Order Page','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td> 
                    <div class="dscfw_border">
                            <label>
                                <input 
                                    type="radio" 
                                    name="signature_order_position" 
                                    value="inside_order_detail" 
                                    <?php checked('inside_order_detail', get_option("signature_order_position", "after_customer_detail")); ?> 
                                />
                                <?php echo esc_html('Inside Order Details Table', 'digital-signature-checkout-for-woocommerce'); ?>
                            </label>
                            <label>
                                <input 
                                    type="radio" 
                                    name="signature_order_position" 
                                    value="after_customer_detail" 
                                    <?php checked('after_customer_detail', get_option("signature_order_position", "after_customer_detail")); ?> 
                                />
                                <?php echo esc_html('Before Customer Address', 'digital-signature-checkout-for-woocommerce'); ?>
                            </label>
                        </div>

                </td>
            </tr>
            <tr>
                <th><label><?php echo esc_html('Enable For Required','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td>
                    <input type="checkbox" name="dscfw_required" value="true" <?php checked('true', get_option("dscfw_required",'false')); ?> disabled>
                    <label><?php echo esc_html('Enable this option for signature required field.','digital-signature-checkout-for-woocommerce'); ?> </label>
                    <div style="margin-top: 20px;">
                        <?php echo __('Some Option Are Only Available in ','digital-signature-checkout-for-woocommerce');?> 
                        <a href="https://topsmodule.com/product/digital-signature-checkout-for-woocommerce/" target="_blank">
                            <?php echo esc_html( __( 'Pro Version', 'digital-signature-checkout-for-woocommerce' ) ); ?>
                        </a>
                    </div>
                </td>
            </tr>
            <tr>
                <th><label><?php echo esc_html('Enable Signature On Products','digital-signature-checkout-for-woocommerce-pro'); ?></label></th>
                <td>
                    <input type="text" name="dscfw_products" value="<?php echo esc_attr(get_option("dscfw_products", '')); ?>" placeholder="101,102,103" disabled/>
                    <p class="description">Please enter product IDs, separated by ","(commas). Make sure there are no spaces between the IDs. Example: <strong>101,102,103</strong></p>
                    <div style="margin-top: 20px;">
                        <?php echo __('Some Option Are Only Available in ','digital-signature-checkout-for-woocommerce');?> 
                        <a href="https://topsmodule.com/product/digital-signature-checkout-for-woocommerce/" target="_blank">
                            <?php echo esc_html( __( 'Pro Version', 'digital-signature-checkout-for-woocommerce' ) ); ?>
                        </a>
                    </div>
                </td>
            </tr>
            <tr>
                <th colspan="2">
                    <h3><?php echo esc_html('Translation','digital-signature-checkout-for-woocommerce'); ?></h3>
                    <div>
                        <?php echo __('Some Option Are Only Available in ','digital-signature-checkout-for-woocommerce');?> 
                        <a href="https://topsmodule.com/product/digital-signature-checkout-for-woocommerce/" target="_blank">
                            <?php echo esc_html( __( 'Pro Version', 'digital-signature-checkout-for-woocommerce' ) ); ?>
                        </a>
                    </div>
                </th>
            </tr>
            <tr>
                <th><label><?php echo esc_html('Draw Signature','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td><input type="text" name="translation_drawsignature" value="<?php echo esc_attr(get_option('translation_drawsignature','Draw Signature')); ?>" disabled></td>
            </tr>
            <tr>
                <th><label><?php echo esc_html('Clear','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td><input type="text" name="translation_clear" value="<?php echo esc_attr(get_option('translation_clear','Clear')); ?>" disabled></td>
            </tr>
            <tr>
                <th><label><?php echo esc_html('Please draw your signature.','digital-signature-checkout-for-woocommerce'); ?></label></th>
                <td><input type="text" name="translation_validation" value="<?php echo esc_attr(get_option('translation_validation','Please draw your signature.')); ?>" disabled></td>
            </tr>
        </table>
        <?php
}


add_action( 'woocommerce_update_options_checkout-signature', 'DSCFW_save_signature_setting' );
function DSCFW_save_signature_setting() {
    if (isset($_REQUEST['signature_width'])) {
        update_option('signature_width', sanitize_text_field($_REQUEST['signature_width']));
    }
    if (isset($_REQUEST['signature_height'])) {
        update_option('signature_height', sanitize_text_field($_REQUEST['signature_height']));
    }
    if (isset($_REQUEST['signature_backcolor'])) {
        update_option('signature_backcolor', sanitize_text_field($_REQUEST['signature_backcolor']));
    }
    if (isset($_REQUEST['signature_penclr'])) {
        update_option('signature_penclr', sanitize_text_field($_REQUEST['signature_penclr']));
    }
    if (isset($_REQUEST['signature_checkout_position'])) {
        update_option('signature_checkout_position', sanitize_text_field($_REQUEST['signature_checkout_position']));
    }
    if (isset($_REQUEST['signature_order_position'])) {
        update_option('signature_order_position', sanitize_text_field($_REQUEST['signature_order_position']));
    }
    if(!empty($_REQUEST['dscfw_required'])) {
        update_option('dscfw_required',sanitize_text_field($_REQUEST['dscfw_required']));
    }else{
        update_option('dscfw_required','');
    }
    if (isset($_REQUEST['dscfw_products'])) {
        update_option('dscfw_products', sanitize_text_field($_REQUEST['dscfw_products']));
    }
    if (isset($_REQUEST['translation_drawsignature'])) {
        update_option('translation_drawsignature', sanitize_text_field($_REQUEST['translation_drawsignature']));
    }
    if (isset($_REQUEST['translation_clear'])) {
        update_option('translation_clear', sanitize_text_field($_REQUEST['translation_clear']));
    }
    if (isset($_REQUEST['translation_validation'])) {
        update_option('translation_validation', sanitize_text_field($_REQUEST['translation_validation']));
    }
}