<?php 
/**
* Plugin Name: Digital Signature Checkout For Woocommerce
* Description: This plugin allows add signature field in checkout page.
* Version: 1.0
* Copyright: 2023
* Text Domain: digital-signature-checkout-for-woocommerce
* Domain Path: /languages 
*/

if (!defined('DSCFW_PLUGIN_DIR')) {
    define('DSCFW_PLUGIN_DIR', plugin_dir_path(__FILE__));
}
if (!defined('DSCFW_PLUGIN_URL')) {
  define('DSCFW_PLUGIN_URL',plugins_url('', __FILE__));
}

include_once(DSCFW_PLUGIN_DIR.'includes/frontend.php');
include_once(DSCFW_PLUGIN_DIR.'includes/admin.php');
include_once(DSCFW_PLUGIN_DIR.'includes/block/block.php');

add_action( 'admin_enqueue_scripts',  'DSCFW_load_script_style_admin');
function DSCFW_load_script_style_admin() {
  wp_enqueue_style( 'wp-color-picker' );
  wp_enqueue_script( 'wp-color-picker-alpha', DSCFW_PLUGIN_URL . '/admin/js/wp-color-picker-alpha.js', array( 'wp-color-picker' ), '1.0.0', true );
}

add_action( 'wp_enqueue_scripts',   'DSCFW_load_script_style');
function DSCFW_load_script_style() {
  wp_enqueue_script('jquery', false, array(), false, false);
	
  if(is_checkout()){
    wp_enqueue_script( 'DSCFW-front-js', DSCFW_PLUGIN_URL .'/public/js/design.js', array('jquery'), '1.0.0' );
    wp_enqueue_script( 'DSCFW-jquery-sign-js', DSCFW_PLUGIN_URL .'/public/js/digital_signature_pad.js', array('jquery'), '1.0.0' );
  }

  $dscfw_products = get_option('dscfw_products', '');

  // Get cart items
  $cart_items = WC()->cart->get_cart();
  $allowed_products = [];
  $pass = false;
  if(!empty($dscfw_products)){
    $allowed_products = explode(',', $dscfw_products);
    foreach ($cart_items as $cart_item) {
      $product_id = $cart_item['product_id']; 

      if (in_array($product_id, $allowed_products)) {
          $pass = true;
          break; // Exit loop early if a match is found
      }
    }
  } else {
    $pass = true;
  }

  $dscfw_arr = array( 
    'ajaxurl' => admin_url( 'admin-ajax.php' ),
    'signature_backcolor' => get_option('signature_backcolor', '#d1d1d1'),
    'signature_penclr' => get_option('signature_penclr', '#000000'),
    'signature_required' => get_option('dscfw_required', 'false'),
    'signature_width' => get_option('signature_width',300),
    'translation_drawsignature' => get_option('translation_drawsignature','Draw Signature'),
    'translation_clear' => get_option('translation_clear','Clear'),
    'translation_validation' => get_option('translation_validation','Please draw your signature.'),
    'pass' => $pass ? 'true' : 'false',
  );
  
  if(get_option("signature_checkout_position", "after_billing")=='before_billing'){
    $dscfw_arr['parent_target'] = 'woocommerce/checkout-contact-information-block';
  }else{
    $data_store = WC_Data_Store::load( 'shipping-zone' );
    $raw_zones = $data_store->get_zones();
    if (count($raw_zones)>0 ) {
      $dscfw_arr['parent_target'] = 'woocommerce/checkout-shipping-address-block';
    }else{
      $dscfw_arr['parent_target'] = 'woocommerce/checkout-billing-address-block';
    }
    
  }
  wp_localize_script( 'DSCFW-front-js', 'signaturecolors', $dscfw_arr );  

  wp_enqueue_style( 'DSCF7-front-css',DSCFW_PLUGIN_URL . '/public/css/design.css', false, '1.0.0' );
}